#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodUnitInactivate : BaseTest 
	{
		
		private DataTable _dtBloodUnit;
		private string _dummyText = System.DateTime.Now.ToString();
		private System.Guid _bloodUnitGuid;
		private VbecsUser _user;
		
		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._user = this.TestUser;
				_user.LogonToDivision( Common.LogonUser.LogonUserDivisionCode );

				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A'",  false);
				if(this._dtBloodUnit.Rows.Count == 0)
				{
					DataCreator.CreateBloodUnit(true);
					this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A'",  true);
				}

				//Create a NewBloodUnit to DeActivate ------------
				_bloodUnitGuid = System.Guid.NewGuid();
				bool isCodabar = (this._dtBloodUnit.Rows[0][TABLES.BloodUnit.LabelTypeCode].ToString() == "C");
				DataCreator.CreateBloodUnit(this._bloodUnitGuid, System.Guid.NewGuid(), System.Guid.Empty, (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid], isCodabar);

				this.RefreshData = false;
			}
		}

		[Test]
		public void IsUnitEligibleForInactivation_Final_Status_Pass()
		{
			string expectedErrorMessage = Common.StrRes.SysErrMsg.UC070.UnitIsInFinalStatus().ResString.TrimStart().TrimEnd();
			//
			// get a unit in final status
			StringBuilder query = new StringBuilder();
			query.Append("SELECT TOP 1 BU.BloodUnitGuid FROM vw_BloodShipAllCurrent BU ");
			query.Append("JOIN BloodUnitStatusCodeCurrent BUSCC on BUSCC.BloodUnitGuid = BU.BloodUnitGuid ");
			query.Append("WHERE	DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("' AND BUSCC.UnitStatusCode IN ('D','M','T','X')");
			//
			DataTable dtRowCount = UnitTestUtil.RunSQLGetDataTable(query.ToString());
			if (dtRowCount.Rows.Count == 0)
			{
				//Create a few units, extra data is always ok
				BOL.BloodUnit tmpMUnit = DataCreator.CreateBloodUnit(false);
				BOL.BloodUnitModification tmpBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, DateTime.Now, Common.LogonUser.LogonUserName);
				tmpBUM.SplitUnit(tmpMUnit.BloodUnitGuid, 2);
				tmpBUM.Save(Common.UpdateFunction.UnitTests);

				BOL.BloodUnit discardUnit = DataCreator.CreateBloodUnit(true);
				Guid commentGuid = DataCreator.GetRandomRecordGuid(TABLES.CannedComment.TableName,"");
				UnitTestUtil.RunSQL("UPDATE BloodUnitStatus SET UnitStatusComments = 'Test3740', UnitStatusDate = GetUtcDate(), DiscardCannedCommentGuid = '" + commentGuid.ToString() + "' WHERE BloodUnitGuid = '" + discardUnit.BloodUnitGuid.ToString() + "'");

				BOL.BloodUnit tmpXUnit = DataCreator.CreateBloodUnit(true);
				string invoiceNumber = new Random().Next(1111111,9999999).ToString();
				BOL.LocalSupplier tmpLS = DataCreator.CreateLocalSupplier();
				BOL.OutgoingShipmentCollection tmpOSC = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(invoiceNumber, tmpLS.LocalSupplierGuid, DateTime.Now, Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
				BOL.OutgoingShipmentCollection.LineItem lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(tmpXUnit.BloodUnitGuid);
				tmpOSC.AddUnitToInvoice(lineItem);
				tmpOSC.SaveChangesToInvoiceItems(new ArrayList(), Common.UpdateFunction.UnitTests);			//unit is not X, confirmation pending 

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogout);
				tmpOSC.ConfirmShipment(DateTime.Now, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.UnitLogout);	//This puts the unit in X
			}

			Assert.IsTrue(FindMessage(query.ToString(), expectedErrorMessage));
		}

		[Test]
		public void IsUnitEligibleForInactivation_Historical_Patient_Assignment_Pass()
		{
			// Save old role
			BOL.UserRole oldRole = _user.DivisionsAndRoles[ Common.LogonUser.LogonUserDivisionCode ].Role;
			//
			_user.DivisionsAndRoles[ Common.LogonUser.LogonUserDivisionCode ].Role = new BOL.UserRole (Common.UserRoleType.EnhancedTechnologist);
			//
			string expectedErrorMessage = "Unit has previous history of patient assignment. You cannot modify this unit.";
			//
			// get a unit with historical patient assignment
			StringBuilder query = new StringBuilder();
			query.Append("SELECT TOP 1 BU.BloodUnitGuid FROM vw_BloodShipAllCurrent BU ");
			query.Append("JOIN OrderedUnit OU ON BU.BloodUnitGuid = OU.BloodUnitGuid ");
			query.Append("WHERE	BU.DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("'");
			//
			DataRow bloodUnitGuidRow = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(query.ToString());
			//
			if (bloodUnitGuidRow == null)
			{
				DataCreator.CreateCrossmatchedBloodUnitTestData();
			}
			//
			Assert.IsTrue(FindMessage(query.ToString(), expectedErrorMessage));
			//
			// Reset role
			_user.DivisionsAndRoles[ Common.LogonUser.LogonUserDivisionCode ].Role = oldRole;
		}

		[Test]
		public void IsUnitEligibleForInactivation_Active_Patient_Assignment_Pass()
		{
			string expectedErrorMessage = Common.StrRes.SysErrMsg.UC070.CannotInactivateUnit().ResString.TrimStart().TrimEnd();
			//
			// get a unit with active patient assignment
			StringBuilder query = new StringBuilder();
			query.Append("SELECT TOP 1 BU.BloodUnitGuid FROM vw_BloodShipAllCurrent BU ");
			query.Append("WHERE	(SELECT COUNT(*) FROM dbo.Patient ");
			query.Append("JOIN Patient P ON P.PatientGuid = dbo.fnGetPatientGuid(dbo.Patient.PatientGuid) ");
			query.Append("JOIN dbo.PatientTreatment ON dbo.Patient.PatientGUID = PatientTreatment.PatientGUID ");
			query.Append("JOIN dbo.PatientOrder ON dbo.PatientTreatment.PatientTreatmentGUID = dbo.PatientOrder.PatientTreatmentGUID ");
			query.Append("JOIN dbo.OrderedComponent ON dbo.PatientOrder.PatientOrderGUID = dbo.OrderedComponent.PatientOrderGUID ");
			query.Append("JOIN dbo.OrderedUnit ON dbo.OrderedComponent.OrderedComponentGuid = dbo.OrderedUnit.OrderedComponentGuid ");
			query.Append("WHERE dbo.OrderedUnit.BloodUnitGUID = BU.BloodUnitGuid ");
			query.Append("AND dbo.OrderedUnit.RecordStatusCode = 'A' AND ReleaseDate IS NULL) > 0 ");
			query.Append("AND BU.DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("'");
			//
			Assert.IsTrue(FindMessage(query.ToString(), expectedErrorMessage));
		}

		[Test]
		public void IsUnitEligibleForInactivation_Active_Tests_Pass()
		{
			string expectedErrorMessage = Common.StrRes.SysErrMsg.UC070.UnitHasActiveTests().ResString.TrimStart().TrimEnd();
			//
			// get a unit with antigen typing tests
			StringBuilder query = new StringBuilder();
			query.Append("SELECT TOP 1 BU.BloodUnitGuid FROM vw_BloodShipAllCurrent BU ");
			query.Append("JOIN BloodUnitTest BUT ON BU.BloodUnitGUID = BUT.BloodUnitGUID ");
			query.Append("JOIN TestResult TR ON TR.TestResultId = BUT.TestResultId ");
			query.Append("JOIN BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID ");
			query.Append("JOIN AntiseraWorklistTyping AWT ON BUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID ");
			query.Append("JOIN AntiseraUnitTest AUT ON AWT.AntiseraWorklistTypingGUID = AUT.AntiseraWorklistTypingGUID ");
			query.Append("JOIN RackLot RL ON AUT.RackLotGUID = RL.RackLotGUID ");
			query.Append("JOIN Reagent R ON RL.ReagentGUID = R.ReagentGUID ");
			query.Append("JOIN OrderableTest OT ON AWT.OrderableTestID = OT.OrderableTestID ");
			query.Append("WHERE	BU.DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("' AND BUT.DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("' AND BUT.RecordStatusCode = 'A' AND R.RecordStatusCode = 'A'AND RL.ControlCellID IS NULL ");
			query.Append("AND AWT.OrderableTestID IN (SELECT OT.OrderableTestID FROM OrderableTest OT ");
			query.Append("JOIN ReagentType RT ON OT.ReagentTypeID = RT.ReagentTypeID ");
			query.Append("WHERE OT.OrderableTestName NOT LIKE 'Repeat%') ");
			//

			DataTable check1 = UnitTestUtil.RunSQLGetDataTable(query.ToString());
			if (check1.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_AntiseraWorklist().Save_Pass_AntigenTyping();
				//Cheating a bit to save time..above method doesn't save TestResultId values, which is needed here
				UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestResultId = '2' WHERE BloodUnitTestGuid IN (SELECT TOP 1 BloodUnitTestGuid FROM BloodUnitTest WHERE BloodTestTypeId = 207 ORDER BY LastUpdateDate DESC)");
				UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestResultId = '2' WHERE BloodUnitTestGuid IN (SELECT TOP 1 BloodUnitTestGuid FROM BloodUnitTest WHERE BloodTestTypeId = 209 ORDER BY LastUpdateDate DESC)");
				UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestResultId = 'P' WHERE BloodUnitTestGuid IN (SELECT TOP 1 BloodUnitTestGuid FROM BloodUnitTest WHERE BloodTestTypeId = 212 ORDER BY LastUpdateDate DESC)");
			}
			Assert.IsTrue(FindMessage(query.ToString(), expectedErrorMessage));
			
			//
			// get a unit with abo rh confirmation tests
			query.Remove(0, query.Length);
			query.Append("SELECT TOP 1 BU.BloodUnitGuid FROM vw_BloodShipAllCurrent BU ");
			query.Append("JOIN BloodUnitTest BUT ON BU.BloodUnitGUID = BUT.BloodUnitGUID ");
			query.Append("JOIN TestResult TR ON TR.TestResultID = BUT.TestResultID ");
			query.Append("JOIN BloodTestType BTT ON BTT.BloodTestTypeID = BUT.BloodTestTypeID ");
			query.Append("WHERE	BU.DivisionCode = '");
			query.Append(Common.LogonUser.LogonUserDivisionCode);
			query.Append("' AND BUT.RecordStatusCode = 'A' AND BUT.BloodTestTypeID IN (15,16,17,18,19,20,21)");
			//
			DataTable check2 = UnitTestUtil.RunSQLGetDataTable(query.ToString());
			if (check2.Rows.Count == 0)
			{
				BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.RBC).BloodProductGuid, true);
				//DataCreator.CreateQCdRack();
				DataCreator.CreateAboRhConfirmationTestsForUnit(tmpUnit.BloodUnitGuid, tmpUnit.BloodUnitMedia.AboRh);
			}

			Assert.IsTrue(FindMessage(query.ToString(), expectedErrorMessage));
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void IsUnitEligibleForInactivation_Fail()
		{
			string message = BloodUnitInactivate.IsUnitEligibleForInactivation(null);
			//
			Assert.AreEqual(0, message.Length, "NoMessage");
		}


		[Test]
		public void InactivateUnit_Pass()
		{
			this.RefreshData = true;
			BOL.BloodUnit objTest = new BOL.BloodUnit(this._bloodUnitGuid);
			System.Collections.ArrayList buas = new System.Collections.ArrayList();
			
			DataTable antigens = BOL.BloodUnitAntigen.GetBloodUnitAntigens(objTest.BloodUnitGuid, objTest.DivisionCode);

			// Added 12/6/2004 RDH			
			System.Collections.ArrayList _bloodUnitAntigens = new System.Collections.ArrayList();

			// Added 12/6/2004 RDH
			foreach(DataRow row in antigens.Rows)
			{
				_bloodUnitAntigens.Add(new BOL.BloodUnitAntigen(row));
			}
			Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
			bool retValue = BOL.BloodUnitInactivate.InactivateUnit(objTest, this._dummyText, Common.UpdateFunction.UnitTests, _bloodUnitAntigens, ref workloadProcessID);

			Assert.AreEqual(true, retValue, "ReturnValue");

			//We created our unit, and so we can KILL IT!
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void InactivateUnit_Fail()
		{
			BOL.BloodUnit objBU = new BOL.BloodUnit(System.Guid.NewGuid());
			Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
			bool retValue = BOL.BloodUnitInactivate.InactivateUnit(objBU, this._dummyText, Common.UpdateFunction.UnitTests, new System.Collections.ArrayList(), ref workloadProcessID);

			Assert.AreEqual(false, retValue, "Inactivate fail");
		}


		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(System.Guid));

			DataRow dr = dtTest.NewRow();

			BOL.BloodUnitInactivate objTest = new BOL.BloodUnitInactivate();
			DataRow drTest = objTest.LoadDataRowFromThis(dr);

			Assert.IsTrue(drTest.Table.Columns.Count == 1);
			Assert.IsTrue(drTest.Table.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		#region Helper Methods

		/// <summary>
		/// FindMessage
		/// </summary>
		private bool FindMessage(string query, string expectedErrorMessage)
		{
			DataRow bloodUnitGuidRow = UnitTestUtil.RunSQLGetDataRow(query);
			//
			Guid bloodUnitGuid = (Guid)bloodUnitGuidRow[TABLES.BloodUnit.BloodUnitGuid];
			//
			BOL.BloodUnit bloodUnit = new BloodUnit(bloodUnitGuid);
			//
			string message = BloodUnitInactivate.IsUnitEligibleForInactivation(bloodUnit);
			//
			string [] messages = message.Split(new char[]{ '\n' });
			//
			bool messageFound = false;
			//
			for (int idx = 0; idx < messages.Length; idx++)
			{
				if(messages[idx].TrimStart().TrimEnd().Equals(expectedErrorMessage))
				{
					messageFound = true;
					break;
				}
			}
			//
			return messageFound;
		}

		#endregion
	}
}
#endif
